#include <wiringPi.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <pthread.h>
#include <sys/time.h>
#include <fcntl.h>
#include <semaphore.h>
#include <sys/types.h>

int alarmOn, currentTemp, setTemp, lightOutside, motion, magSwitchOpen, shadesUp, playSpeaker;

void *speakersThread(void *args) {							//play speaker if playSpeaker = 1
	while(1) {
		if (playSpeaker) {
			system("omxplayer -o local example.mp3");		//through a system call
			sleep(3);										//sleep long enough for full speaker sound
		}
	}
}

void *messageThread (void *args) {
	char buffer[100];
	char temp[100];
	int i, c;
	
	while(1) {
		
		i = 0;
		
		while(EOF != (c = fgetc(stdin))) {					//read in the pipe info
				buffer[i++] = c;
		}
		
		buffer[i] = '\0';									//end in terminating character
		
		if (strncmp(buffer, "tempSet", 7) == 0) {			//determine the incoming message
			temp = strtok(buffer, ' ');
			temp = strtok(NULL, ' ');
			
			setTemp = atoi(temp);
		}
		else if (strcmp(buffer, "alarmOn") == 0) {			//set alarmm if enabled
			alarmOn = 1;
		}
		else if (strcmp(buffer, "alarmOff") == 0) {
			alarmOn = 0;
		}
		
	}
	
	
	
	
}

void *logicThread (void *args) {						//thread that determines the logic of the program
	while(1) {
		if (alarmOn) {									//if the alarm is set
			if (motion | magSwitchOpen) {				//if the motion senor or the magnetic switch goes off
				playSpeaker = 1;						//sound the alarm
			}
		}
		
		if (!alarmOn) {									//if alarm is disabled
			playSpeaker = 0;							//turn off the alarm
		}
		
		if (currentTemp < setTemp) {					//if the current temp is less than the temp that was user set
			if (lightOutside & !shadesUp) {				//if it is light outside and the shades down
				//open blinds							//open the blinds
			}
		}
		
		if (currentTemp > setTemp) {					//if the current temp is more than the temp that was set by the user
			if (lightOutside & shadesUp) {				//if it is light outside and the shades are up
				//lower blinds							//lower the blinds
			}
		}
		
		if (!lightOutside & shadesUp) {					//if it is dark outside and the shades are up
			//lower blinds								//lower the blinds
		}
	}
}

void *monitorTempThread (void *args) {
	double adc, millivolts, tempC;
	
	while (1) {
		//didn't get an adc
		//lost implementation of current temperature readings
		
		//if I did have a proper adc then here is what the code would look like:
		
		/*
		analogData = readadc.readadc( sensor_pin,
									  readadc.PINS.SPICLK,
									  readadc.PINS.SPIMOSI,
									  readadc.PINS.SPIMISO,
									  readadc.PINS.SPICS);
									  
		millivolts = analogData * (5000/1024);
		tempC = ((millivolts - 100) / 10) - 40;
		
		currentTemp = "%.1f" % tempC;
		*/
	}
}

void *monitorLightThread (void *args) {
	int reading;
	
	while (1) {
		reading = 0;
		
		pinMode(16, OUTPUT);				//set the photocell to output and low
		digitalWrite(16, LOW);				//allows the capacitor to discharge
		
		usleep(10000);						//sleep to let the capacitor to discharge completely
		
		pinMode(16, INPUT);					//set it to input
		
		while (digitalRead(16) == 0)		//read the input until the read is now digital high
			reading += 1;					//more counts ~ longer time it takes to fill capacitor ~ higher resistance ~ more light
		
		if (reading < 100)					//number of counts that is determined to be the cutoff between light or no light
			lightOutside = 1;
		else
			lightOutside = 0;
			
	}
}

void *monitorSwitchThread (void *args) {	//thread that checks the magnetic switch
	if (digitalRead(20))					//if it is high / opened
		magSwitchOpen = 1;
	else									//if it is low / closed
		magSwitchOpen = 0;
}

void *monitorMotionThread (void *args) {	//thread to monitor the motion sensor
	if (digitalRead(21))					//if it is high / passed by
		motion = 1;
	else									//if it is low /  un passed by
		motion = 0;	
}

int main (void) {
	
	wiringPiSetup();			//set up the GPIO
	wiringPiSetupGpio();
	
	pinMode(12, INPUT);			//temp sensor
	pinMode(16, INPUT);			//light sensor
	pinMode(20, INPUT);			//magnetic switch
	pinMode(21, INPUT);			//motion sensor
	pinMode(13, OUTPUT);		//motor
	pinMode(19, OUTPUT);		//air flow system

	pthread_t message, logic, monitorTemp, monitorLight, monitorSwitch, monitorMotion, speaker;

	pthread_create(&message, 		NULL, messagethread, 		NULL);	//create the threads necessary to check the external devices and process the logic to the global variables
	pthread_create(&logic, 			NULL, logicThread, 			NULL);
	pthread_create(&monitorTemp, 	NULL, monitorTempThread, 	NULL);
	pthread_create(&monitorLight, 	NULL, monitorLightThread, 	NULL);
	pthread_create(&monitorSwitch, 	NULL, monitorSwitchThread, 	NULL);
	pthread_create(&monitorMotion, 	NULL, monitorMotionThread, 	NULL);
	pthread_create(&speaker,	 	NULL, speakerThread,	 	NULL);

	while(1) {}
	
	return 0;	
}

